//
//  DirectoryTest.swift
//  SystemDirectoryTest
//
//  Created by Cagylogic on 2015/01/19.
//  Copyright (c) 2015年 cagylogic. All rights reserved.
//

import Foundation

extension NSSearchPathDirectory : Printable {
    
    public static let allValues : [NSSearchPathDirectory] = [
        
        .ApplicationDirectory, // supported applications (Applications)
        .DemoApplicationDirectory, // unsupported applications, demonstration versions (Demos)
        .DeveloperApplicationDirectory, // developer applications (Developer/Applications). DEPRECATED - there is no one single Developer directory.
        .AdminApplicationDirectory, // system and network administration applications (Administration)
        .LibraryDirectory, // various documentation, support, and configuration files, resources (Library)
        .DeveloperDirectory, // developer resources (Developer) DEPRECATED - there is no one single Developer directory.
        .UserDirectory, // user home directories (Users)
        .DocumentationDirectory, // documentation (Documentation)
        .DocumentDirectory, // documents (Documents)
        .CoreServiceDirectory, // location of CoreServices directory (System/Library/CoreServices)
        .AutosavedInformationDirectory, // location of autosaved documents (Documents/Autosaved)
        .DesktopDirectory, // location of user's desktop
        .CachesDirectory, // location of discardable cache files (Library/Caches)
        .ApplicationSupportDirectory, // location of application support files (plug-ins, etc) (Library/Application Support)
        .DownloadsDirectory, // location of the user's "Downloads" directory
        .InputMethodsDirectory, // input methods (Library/Input Methods)
        .MoviesDirectory, // location of user's Movies directory (~/Movies)
        .MusicDirectory, // location of user's Music directory (~/Music)
        .PicturesDirectory, // location of user's Pictures directory (~/Pictures)
        .PrinterDescriptionDirectory, // location of system's PPDs directory (Library/Printers/PPDs)
        .SharedPublicDirectory, // location of user's Public sharing directory (~/Public)
        .PreferencePanesDirectory, // location of the PreferencePanes directory for use with System Preferences (Library/PreferencePanes)
        .ApplicationScriptsDirectory, // location of the user scripts folder for the calling application (~/Library/Application Scripts/code-signing-id)
        .ItemReplacementDirectory, // For use with NSFileManager's URLForDirectory:inDomain:appropriateForURL:create:error:
        .AllApplicationsDirectory, // all directories where applications can occur
        .AllLibrariesDirectory, // all directories where resources can occur
        .TrashDirectory // location of Trash directory
    ]
    
    public var description : String {
        
        switch self {
        case .ApplicationDirectory: // supported applications (Applications)
            return "ApplicationDirectory"
        case .DemoApplicationDirectory: // unsupported applications, demonstration versions (Demos)
            return "DemoApplicationDirectory"
        case .DeveloperApplicationDirectory: // developer applications (Developer/Applications). DEPRECATED - there is no one single Developer directory.
            return "DeveloperApplicationDirectory"
        case .AdminApplicationDirectory: // system and network administration applications (Administration)
            return "AdminApplicationDirectory"
        case .LibraryDirectory: // various documentation, support, and configuration files, resources (Library)
            return "LibraryDirectory"
        case .DeveloperDirectory: // developer resources (Developer) DEPRECATED - there is no one single Developer directory.
            return "DeveloperDirectory"
        case .UserDirectory: // user home directories (Users)
            return "UserDirectory"
        case .DocumentationDirectory: // documentation (Documentation)
            return "DocumentationDirectory"
        case .DocumentDirectory: // documents (Documents)
            return "DocumentDirectory"
        case .CoreServiceDirectory: // location of CoreServices directory (System/Library/CoreServices)
            return "CoreServiceDirectory"
        case .AutosavedInformationDirectory: // location of autosaved documents (Documents/Autosaved)
            return "AutosavedInformationDirectory"
        case .DesktopDirectory: // location of user's desktop
            return "DesktopDirectory"
        case .CachesDirectory: // location of discardable cache files (Library/Caches)
            return "CachesDirectory"
        case .ApplicationSupportDirectory: // location of application support files (plug-ins, etc) (Library/Application Support)
            return "ApplicationSupportDirectory"
        case .DownloadsDirectory: // location of the user's "Downloads" directory
            return "DownloadsDirectory"
        case .InputMethodsDirectory: // input methods (Library/Input Methods)
            return "InputMethodsDirectory"
        case .MoviesDirectory: // location of user's Movies directory (~/Movies)
            return "MoviesDirectory"
        case .MusicDirectory: // location of user's Music directory (~/Music)
            return "MusicDirectory"
        case .PicturesDirectory: // location of user's Pictures directory (~/Pictures)
            return "PicturesDirectory"
        case .PrinterDescriptionDirectory: // location of system's PPDs directory (Library/Printers/PPDs)
            return "PrinterDescriptionDirectory"
        case .SharedPublicDirectory: // location of user's Public sharing directory (~/Public)
            return "SharedPublicDirectory"
        case .PreferencePanesDirectory: // location of the PreferencePanes directory for use with System Preferences (Library/PreferencePanes)
            return "PreferencePanesDirectory"
        case .ApplicationScriptsDirectory: // location of the user scripts folder for the calling application (~/Library/Application Scripts/code-signing-id)
            return "ApplicationScriptsDirectory"
        case .ItemReplacementDirectory: // For use with NSFileManager's URLForDirectory:inDomain:appropriateForURL:create:error:
            return "ItemReplacementDirectory"
        case .AllApplicationsDirectory: // all directories where applications can occur
            return "AllApplicationsDirectory"
        case .AllLibrariesDirectory: // all directories where resources can occur
            return "AllLibrariesDirectory"
        case .TrashDirectory: // location of Trash directory
            return "TrashDirectory"
        }
    }
}

extension NSSearchPathDomainMask : Printable {
    
    public static let allValues : [NSSearchPathDomainMask] = [
        .UserDomainMask, // user's home directory --- place to install user's personal items (~)
        .LocalDomainMask, // local to the current machine --- place to install items available to everyone on this machine (/Library)
        .NetworkDomainMask, // publically available location in the local area network --- place to install items available on the network (/Network)
        .SystemDomainMask, // provided by Apple, unmodifiable (/System)
        .AllDomainsMask // all domains: all of the above and future items
    ]
    
    public var description : String {
        
        if self == .UserDomainMask {
            
            return "UserDomainMask"
        }
        if self == .LocalDomainMask {
            
            return "LocalDomainMask"
        }
        if self == .NetworkDomainMask {
            
            return "NetworkDomainMask"
        }
        if self == .SystemDomainMask {
            
            return "SystemDomainMask"
        }
        if self == .AllDomainsMask {
            
            return "AllDomainsMask"
        }
        
        return "Mixed"
    }
}

func SearchPathForDirectoriesInDomains(directory: NSSearchPathDirectory,
    domainMask: NSSearchPathDomainMask,
    expandTilde: Bool) {
        
        let result = NSSearchPathForDirectoriesInDomains(directory, domainMask, expandTilde);
        println("\(expandTilde), \(domainMask), \(directory), \(result)")
}

func URLsForDirectory(fileManager: NSFileManager,
    directory: NSSearchPathDirectory,
    domainMask: NSSearchPathDomainMask) {
        
        let result = fileManager.URLsForDirectory(directory, inDomains: domainMask)
        println("\(domainMask), \(directory), \(result)")
}

func TEST() {
    
/*    for expandTilde in [true,false] {
        for domainMask in NSSearchPathDomainMask.allValues {
            for directory in NSSearchPathDirectory.allValues {
                
                SearchPathForDirectoriesInDomains(directory, domainMask, expandTilde)
            }
        }
    }*/

    var fileManager = NSFileManager()
    for domainMask in NSSearchPathDomainMask.allValues {
        for directory in NSSearchPathDirectory.allValues {
            
            URLsForDirectory(fileManager, directory, domainMask)
        }
    }
}

